/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.gameSelector;

import ags.game.Game;
import ags.ui.FrameBasedWidget;
import ags.ui.IApplication;
import ags.ui.IWidget;
import ags.ui.gameSelector.GameSelectorApplication;
import ags.ui.gameSelector.SelectWidget;
import ags.ui.gameSelector.TextWidget;
import java.util.ArrayList;
import java.util.List;

public class GameSearchWidget
extends FrameBasedWidget {
    public static final String SELECT_CONTAINS = "Contains";
    public static final String SELECT_STARTS_WITH = "Starts with";
    public static final String SELECT_ENDS_WITH = "Ends with";
    public static final String SELECT_EQUALS = "Equals";
    public static final String SELECT_BEFORE = "Before";
    public static final String SELECT_AFTER = "After";
    public static final String SELECT_ANY = "Any";
    public static final String SELECT_YES = "Yes";
    public static final String SELECT_NO = "No";
    List<IWidget> searchWidgets = new ArrayList<IWidget>();
    SelectWidget titleType;
    TextWidget titleText;
    SelectWidget authorType;
    TextWidget authorText;
    SelectWidget yearType;
    TextWidget yearText;
    SelectWidget keyboard;
    SelectWidget joystick;
    SelectWidget mouse;
    List<Game> results;

    public GameSearchWidget(IApplication a) {
        super(a);
        this.titleType = new SelectWidget(a);
        this.titleType.setX(9);
        this.titleType.setY(3);
        this.titleType.setOptions(SELECT_CONTAINS, SELECT_STARTS_WITH, SELECT_ENDS_WITH);
        this.titleText = new TextWidget(a);
        this.titleText.setX(23);
        this.titleText.setY(3);
        this.titleText.setXSize(15);
        this.authorType = new SelectWidget(a);
        this.authorType.setX(9);
        this.authorType.setY(6);
        this.authorType.setOptions(SELECT_CONTAINS, SELECT_STARTS_WITH, SELECT_ENDS_WITH);
        this.authorText = new TextWidget(a);
        this.authorText.setX(23);
        this.authorText.setY(6);
        this.authorText.setXSize(15);
        this.yearType = new SelectWidget(a);
        this.yearType.setX(9);
        this.yearType.setY(9);
        this.yearType.setOptions(SELECT_EQUALS, SELECT_BEFORE, SELECT_AFTER);
        this.yearText = new TextWidget(a);
        this.yearText.setX(23);
        this.yearText.setY(9);
        this.yearText.setXSize(5);
        this.keyboard = new SelectWidget(a);
        this.keyboard.setX(17);
        this.keyboard.setY(12);
        this.keyboard.setOptions(SELECT_ANY, SELECT_YES, SELECT_NO);
        this.joystick = new SelectWidget(a);
        this.joystick.setX(17);
        this.joystick.setY(15);
        this.joystick.setOptions(SELECT_ANY, SELECT_YES, SELECT_NO);
        this.mouse = new SelectWidget(a);
        this.mouse.setX(17);
        this.mouse.setY(18);
        this.mouse.setOptions(SELECT_ANY, SELECT_YES, SELECT_NO);
        this.searchWidgets.add(this.titleText);
        this.searchWidgets.add(this.authorType);
        this.searchWidgets.add(this.authorText);
        this.searchWidgets.add(this.yearType);
        this.searchWidgets.add(this.yearText);
        this.searchWidgets.add(this.keyboard);
        this.searchWidgets.add(this.joystick);
        this.searchWidgets.add(this.mouse);
        this.searchWidgets.add(this.titleType);
    }

    public boolean isActive() {
        for (IWidget w : this.searchWidgets) {
            if (!w.isActive()) continue;
            return true;
        }
        return super.isActive();
    }

    public void setActive(boolean active) {
        if (active) {
            this.app.moveToBottom(this);
        }
        super.setActive(active);
    }

    public void show() {
        for (IWidget w : this.searchWidgets) {
            this.app.addWidget(w);
        }
    }

    public void hide() {
        for (IWidget w : this.searchWidgets) {
            this.app.removeWidget(w);
        }
    }

    public void redrawInside() {
        this.processSearch();
        String title = "Game Search";
        this.app.getScreen().drawText(this.getX() + (this.getXSize() - title.length()) / 2, 0, title, true);
        title = this.results == null || this.results.size() == 0 ? "No results found" : "Found " + this.results.size() + " results";
        this.app.getScreen().drawText(this.getX() + (this.getXSize() - title.length()) / 2, 23, title, true);
        this.app.getScreen().drawText(1, 3, " Title:", false);
        this.app.getScreen().drawText(1, 6, "Author:", false);
        this.app.getScreen().drawText(1, 9, "  Year:", false);
        this.app.getScreen().drawText(6, 12, " Keyboard:", false);
        this.app.getScreen().drawText(6, 15, " Joystick:", false);
        this.app.getScreen().drawText(6, 18, "    Mouse:", false);
        this.app.getScreen().drawText(22, 11, "TAB switches     ", false);
        this.app.getScreen().drawText(22, 12, "between fields   ", false);
        this.app.getScreen().drawText(22, 14, "ARROW KEYS move  ", false);
        this.app.getScreen().drawText(22, 15, "inside fields    ", false);
        this.app.getScreen().drawText(22, 17, "RETURN views     ", false);
        this.app.getScreen().drawText(22, 18, "search results   ", false);
        this.app.getScreen().drawText(22, 20, "ESC shows all,   ", false);
        this.app.getScreen().drawText(22, 21, "cancelling search", false);
    }

    public boolean handleKeypress(byte b) {
        return false;
    }

    private void processSearch() {
        String compare;
        ArrayList<Game> tempResults;
        GameSelectorApplication a = (GameSelectorApplication)this.app;
        this.results = new ArrayList<Game>(a.games);
        String text = this.authorText.getValue().toUpperCase();
        if (text != null && !"".equals(text)) {
            tempResults = new ArrayList<Game>(this.results);
            for (Game g : this.results) {
                if (g.getAuthor() == null || "".equals(g.getAuthor())) {
                    tempResults.remove(g);
                    continue;
                }
                compare = g.getAuthor().toUpperCase();
                if (this.authorType.getCurrentOption().equals(SELECT_STARTS_WITH) && !compare.startsWith(text)) {
                    tempResults.remove(g);
                }
                if (this.authorType.getCurrentOption().equals(SELECT_ENDS_WITH) && !compare.endsWith(text)) {
                    tempResults.remove(g);
                }
                if (!this.authorType.getCurrentOption().equals(SELECT_CONTAINS) || compare.contains(text)) continue;
                tempResults.remove(g);
            }
            this.results = tempResults;
        }
        if ((text = this.titleText.getValue().toUpperCase()) != null && !"".equals(text)) {
            tempResults = new ArrayList<Game>(this.results);
            for (Game g : this.results) {
                compare = g.getName().toUpperCase();
                if (this.titleType.getCurrentOption().equals(SELECT_STARTS_WITH) && !compare.startsWith(text)) {
                    tempResults.remove(g);
                }
                if (this.titleType.getCurrentOption().equals(SELECT_ENDS_WITH) && !compare.endsWith(text)) {
                    tempResults.remove(g);
                }
                if (!this.titleType.getCurrentOption().equals(SELECT_CONTAINS) || compare.contains(text)) continue;
                tempResults.remove(g);
            }
            this.results = tempResults;
        }
        if ((text = this.yearText.getValue().toUpperCase()) != null && !"".equals(text)) {
            tempResults = new ArrayList<Game>(this.results);
            for (Game g : this.results) {
                if (g.getYear() == null || "".equals(g.getYear())) {
                    tempResults.remove(g);
                    continue;
                }
                compare = g.getYear().toUpperCase();
                if (this.yearType.getCurrentOption().equals(SELECT_BEFORE) && compare.compareTo(text) >= 0) {
                    tempResults.remove(g);
                }
                if (this.yearType.getCurrentOption().equals(SELECT_AFTER) && compare.compareTo(text) <= 0) {
                    tempResults.remove(g);
                }
                if (!this.yearType.getCurrentOption().equals(SELECT_EQUALS) || compare.compareTo(text) == 0) continue;
                tempResults.remove(g);
            }
            this.results = tempResults;
        }
        if (!this.keyboard.getCurrentOption().equals(SELECT_ANY)) {
            tempResults = new ArrayList<Game>(this.results);
            for (Game g : this.results) {
                if (g.isSupportsKeyboard() == null) {
                    tempResults.remove(g);
                    continue;
                }
                if (this.keyboard.getCurrentOption().equals(SELECT_YES) && !g.isSupportsKeyboard().booleanValue()) {
                    tempResults.remove(g);
                }
                if (!this.keyboard.getCurrentOption().equals(SELECT_NO) || !g.isSupportsKeyboard().booleanValue()) continue;
                tempResults.remove(g);
            }
            this.results = tempResults;
        }
        if (!this.joystick.getCurrentOption().equals(SELECT_ANY)) {
            tempResults = new ArrayList<Game>(this.results);
            for (Game g : this.results) {
                if (g.isSupportsJoystick() == null) {
                    tempResults.remove(g);
                    continue;
                }
                if (this.joystick.getCurrentOption().equals(SELECT_YES) && !g.isSupportsJoystick().booleanValue()) {
                    tempResults.remove(g);
                }
                if (!this.joystick.getCurrentOption().equals(SELECT_NO) || !g.isSupportsJoystick().booleanValue()) continue;
                tempResults.remove(g);
            }
            this.results = tempResults;
        }
        if (!this.mouse.getCurrentOption().equals(SELECT_ANY)) {
            tempResults = new ArrayList<Game>(this.results);
            for (Game g : this.results) {
                if (g.isSupportsMouse() == null) {
                    tempResults.remove(g);
                    continue;
                }
                if (this.mouse.getCurrentOption().equals(SELECT_YES) && !g.isSupportsMouse().booleanValue()) {
                    tempResults.remove(g);
                }
                if (!this.mouse.getCurrentOption().equals(SELECT_NO) || !g.isSupportsMouse().booleanValue()) continue;
                tempResults.remove(g);
            }
            this.results = tempResults;
        }
        a.setResults(this.results);
    }
}

